﻿
/*:ja
 * @plugindesc 戦闘中立ち絵表示プラグイン
 * @author 村人A
 *
 * @help
 * 
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * バージョン情報
 * 
 * 21/07/27 バージョン1.141 リリース
 * 衣装変更強制し、そのまま戦闘を終わり、再度先頭に入った際に発生するエラーを修正
 * 低HPで開始し、立ち絵が切り替わる際に前の立ち絵が残っていしまう不具合を修正
 * 
 * 21/05/27 バージョン1.13 リリース
 * 攻撃時のログとアニメーションのタイミングに違和感がある不具合を修正
 * 
 * 21/05/26 バージョン1.12 リリース
 * 敵の攻撃時のみ攻撃アニメーション後にダメージホップアップするように修正
 * 
 * 21/05/24 バージョン1.1 リリース
 * 攻撃アニメーション後にダメージホップアップなどが表示されるように修正
 * 
 * 20/01/25 バージョン0.91 リリース
 * 攻撃スキルの立ち絵の設定時にエラーが発生する現象への対策
 * 
 * 20/01/24 バージョン0.9　リリース
 * 
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * ========================================
 * 以下ヘルプ
 * ========================================
 * このプラグインは戦闘中に立ち絵を表示するプラグインです。
 * 
 * ●立ち絵に使用する画像の保存場所
 * 
 * img/battleStandPicture/アクター名/半角数字/
 * 
 * となります。
 * アクター名はデータベースのアクターの名前を使用してください。
 * 現在の仕様では戦闘パーティーの一番最初のアクターが対象となります。
 * 半角数字はプラグインパラメータ「立ち絵を変化させる変数ＩＤ」にて指定した変数に
 * 対応した衣装となります。
 * アクター名がハロルドの変数が０だった場合の立ち絵を保存したい場合
 * 
 * img/battleStandPicture/ハロルド/0/
 * 
 * フォルダから参照されます。
 * 
 * ●基本設定
 * アニメーションの位置やダメージ表示、その他画像表示関係の調節のため使用する画像
 * の大きさをプラグインパラメータ「立ち絵画像の基本位置」に高さ,幅で記述してください
 * 立ち絵を表示する位置はプラグインパラメータ「立ち絵の位置」にて変更できます。
 * ダメージを受けた際やスキル・アイテム発生時は指定したフレーム数立ち絵が変更されます。
 * 変更するフレーム数はプラグインパラメータ「立ち絵継続フレーム数」にて設定されます。
 * また、ダメージを受けた際に立ち絵をシェイクするようにしています。
 * シェイクの振幅や振動数はプラグインパラメータ「ダメージを受けた際の振動の強さ」、
 * 「ダメージを受けた際の振動数」にて設定して下さい。
 * 
 * 
 * ●スキル発生時の立ち絵の設定の仕方
 * スキルのデータベースのメモ欄にて
 * 
 * <standPic:画像名１,画像名２,…>
 * 
 * と記述してください。
 * 画像名は複数記述することでスキル発生時ランダムで表示されます。
 * 半角カンマ,を挟んで画像名を羅列してください。
 * 例えばskill1-1,skill1-2,skill1-3という画像名を設定したい場合は
 * 
 * <standPic:skill1-1,skill1-2,skill1-3>
 * 
 * と記述します。
 * 
 * また、スキル発生時の立ち絵の変更するフレーム数についてはスキルのデータベースメ
 * モ欄にて
 * 
 * <changePicFrame:フレーム数>
 * 
 * と記述して下さい。
 * 例えば60フレームの間だけ変更したい場合は
 * 
 * <changePicFrame:60>
 * 
 * と記述します。
 * 何も記述がない場合はプラグインパラメータ「立ち絵継続フレーム数」にて設定したフ
 * レーム数が適用されます。
 * 
 * 
 * ●ステート時の立ち絵の設定の仕方
 * 立ち絵を変更したいステートのデータベースのメモ帳にて
 * 
 * <BSPC:画像名>
 * 
 * と記述してください。
 * 例えばそのステートになった際にspState2という画像名の立ち絵にしたい場合
 * 
 * <BSPC:spState2>
 * 
 * と記述します。
 * 
 * 
 * ●立ち絵の衣装を変更する方法
 * 
 * 立ち絵の衣装を変更したい場合、変数によって変更されます。
 * 変更に使用する変数のＩＤはプラグインパラメータ「立ち絵を変化させる変数ＩＤ」
 * にて設定されます。
 * 
 * 戦闘中に立ち絵を変更したい場合は変数の操作の後にプラグインコマンド「衣装変数の
 * 変更」を必ず設定してください。
 * 変更が反映されません。
 * 
 * 
 * ●通常の立ち絵を強制的に変更する方法
 * 
 * 通常の立ち絵を強制的に変更したい場合はプラグインコマンド「衣装変更強制」を記述
 * し、半角スペースを挟んで画像名を指定してください。
 * 例えば通常立ち絵を「force1」に変更したい場合は
 * 
 * 衣装変更強制 force1
 * 
 * と記述して下さい。
 * 
 * 
 * ●通常の立ち絵の透過度を変更する方法
 * 立ち絵の透過度を変更したい場合、プラグインコマンド「立ち絵透過度変更」を記述し、
 * 半角スペースを挟んで半角数字で透過度を指定してください。
 * 透過度は0～255の間で指定してください。
 * 
 * 例えば透過度を150にしたい場合
 * 
 * 立ち絵透過度変更 150
 * 
 * と記述します。
 * 
 * 
 * @param 立ち絵の位置
 * @desc 立ち絵を表示する位置を半角カンマ,を挟んで半角数字でx,y座標で指定してください。
 * @default 700,200
 * 
 * @param 立ち絵画像の基本位置
 * @desc 立ち絵に使用する画像の通常時の画像の大きさを記述してください。
 * @default 500,500
 *
 * @param HPの割合とその立ち絵名
 * @desc HPの割合とそれに対応する立ち絵画像名をhpの多い順で半角スラッシュ/を挟んで１組で、半角カンマ,を挟んで指定します。
 * @default 50/halfHP,25/lowHP,0/defeat
 *
 * @param 立ち絵継続フレーム数
 * @desc ダメージを受けたとき等一時的に立ち絵を変更する際に継続するフレーム数
 * @default 40
 *
 * @param 「攻撃」に使用しているスキルのID
 * @desc デフォルトで1番に設定されている「攻撃」に設定しているスキルの番号（無い場合は0と記述して下さい）
 * @default 1
 *
 * @param 立ち絵を変化させる変数ＩＤ
 * @desc 衣装による変化を出すために使用する変数のＩＤを指定します。
 * @default 1
 *
 * @param ダメージを受けた際の振動の強さ
 * @desc ダメージを受けた際の立ち絵の振動の強さを指定します。数値が大きいほど大きく振動します。
 * @default 5
 *
 * @param ダメージを受けた際の振動数
 * @desc ダメージを受けた際の立ち絵の振動数を指定します。立ち絵継続フレーム数を割り切れる数を指定してください。
 * @default 4
 *
 *
 */
 
(function() {
	'use strict';
	
	String.prototype.toConvertNumberArray = function(){
		return this.split(',').map(function(str){return Number(str)});
	}
	
    let parameters = PluginManager.parameters('OriginalBattleStandPicture');
	const BattleStandPosition = parameters['立ち絵の位置'].toConvertNumberArray();
	const BattleStandSize = parameters['立ち絵画像の基本位置'].toConvertNumberArray();
	const HPRateAndFileName = parameters['HPの割合とその立ち絵名'].split(",").map(function(str){return str.split("/")});
	const changeFrameCount = Number(parameters['立ち絵継続フレーム数']);
	const ChangeByClothingVariableId = Number(parameters['立ち絵を変化させる変数ＩＤ']);
	const damageShakeAmplitude = Number(parameters['ダメージを受けた際の振動の強さ']);
	const damageShakeFrequency = Number(parameters['ダメージを受けた際の振動数']);
	const nomalAttackSkillId = Number(parameters['「攻撃」に使用しているスキルのID']);
	
	//-----------------------------------------------------------------------------
	// ImageManager
	//

	ImageManager.loadBattleStandPicture = function(filename, actorName, val, hue) {
		return this.loadBitmap('img/battleStandPicture/' + actorName + '/' + val + '/', filename, hue, false);
	};

	//-----------------------------------------------------------------------------
	// Game_Interpreter
	//

    const _alias_Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _alias_Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === '衣装変数の変更') {
			if(!$gameParty.inBattle()){return};
			BattleManager._spriteset.changeClothsVariables();
		}
        if (command === '衣装変更強制') {
			$gameSystem.battleStandForceNomalName = args[0];
			BattleManager._spriteset.loadNewNomalBattleStandPicture(args[0])
		}
        if (command === '衣装変更強制の解除') {
			$gameSystem.battleStandForceNomalName = null;
		}
        if (command === '立ち絵透過度変更') {
			if(!$gameParty.inBattle()){return};
			BattleManager._spriteset.setBattleStandPictureTraslate(Number(args[0]));
		}
	}
	//-----------------------------------------------------------------------------
	// BattleManager
	//
	
    const _alias_BattleManager_invokeAction = BattleManager.invokeAction;
	BattleManager.invokeAction = function(subject, target) {
		_alias_BattleManager_invokeAction.call(this, subject, target)
		if(!target.isActor()){return}
		if(subject.isActor()){return}
		let actionName = "damage";
		if(target.result().missed || target.result().evaded){
			actionName = "avoid";
		} else if(target.result().hpDamage == 0){
			actionName = "noDamage";
		}
		this._spriteset.setOneStandPicture(actionName, target)
	}

    const _alias_BattleManager_startAction = BattleManager.startAction;
	BattleManager.startAction = function() {
		const subject = this._subject;
		const action = subject.currentAction();
		_alias_BattleManager_startAction.call(this);
		if(subject.isActor()){
			if(action.isItem()){
				this._spriteset.setItemStandPicture(subject);
			} else {
				this._spriteset.setSkillStandPicture(action.item().id, subject);
			}
		}
	};
	
	//ターン終了時に通常立ち絵に戻す
    const _alias_BattleManager_processTurn = BattleManager.processTurn;
	BattleManager.processTurn = function() {
		this._spriteset.setAllMemberNomalStandPicture();
		_alias_BattleManager_processTurn.call(this);
	}
	
	//-----------------------------------------------------------------------------
	// Window_BattleLog
	//
	
	//21/05/27 追記
	const _alias_Window_BattleLog_displayAction = Window_BattleLog.prototype.displayAction;
	Window_BattleLog.prototype.displayAction = function(subject, item) {
		if(!subject.isActor()){this.setWaitMode('animation')}
		_alias_Window_BattleLog_displayAction.call(this, subject, item)
	}

	//21/05/24 追記
	const _alias_Window_BattleLog_updateWaitMode = Window_BattleLog.prototype.updateWaitMode;
	Window_BattleLog.prototype.updateWaitMode = function() {
		if(this._waitMode == 'animation'){
			let waiting = this._spriteset.isAnimationPlaying();
			if(!waiting){this._waitMode = ''}
			return waiting;
		} else {
			return _alias_Window_BattleLog_updateWaitMode.call(this);
		}
	};

	//-----------------------------------------------------------------------------
	// Spriteset_Battle
	//

    const _alias_Spriteset_Battle_createActors = Spriteset_Battle.prototype.createActors;
	Spriteset_Battle.prototype.createActors = function() {
		_alias_Spriteset_Battle_createActors.call(this);
		this.createBattleStandPicture();
	}

	Spriteset_Battle.prototype.createBattleStandPicture = function() {
		this.battleStandPictures = []
		$gameParty.battleMembers().forEach(function(actor, index){
			if(index > 0){return} //立ち絵表示するアクターが一人のみにする
			const sprite = new Sprite_BattleStandPicture(actor, BattleStandPosition);
			this.addChild(sprite);
			sprite.setMainSprite()
			this.battleStandPictures.push(sprite);
		}.bind(this))
	}
	
	Spriteset_Battle.prototype.changeClothsVariables = function() {
		this.battleStandPictures.forEach(sprite => sprite.refreshClothes())
	}
	
	Spriteset_Battle.prototype.setBattleStandPictureTraslate = function(value) {
		this.battleStandPictures.forEach(sprite => sprite.opacity = value)
	}
	
	Spriteset_Battle.prototype.setOneStandPicture = function(name, actor, frame = changeFrameCount) {
		const ind = $gameParty.battleMembers().indexOf(actor);
		this.battleStandPictures[ind].changePicture(name, frame)
	}
	
	/*
	全ての戦闘立ち絵を指定した立ち絵にする
	Spriteset_Battle.prototype.setAllStandPicture = function(name) {
		this.battleStandPictures.forEach(sprite => sprite.changePicture(name));
	}
	*/
	
	Spriteset_Battle.prototype.setAllMemberNomalStandPicture = function() {
		$gameParty.battleMembers().forEach(function(actor){
			const ind = $gameParty.battleMembers().indexOf(actor);
			this.battleStandPictures[ind].changeNomalPicture();
		}.bind(this))
	}
	
	Spriteset_Battle.prototype.setItemStandPicture = function(actor) {
		this.setOneStandPicture("item", actor);
	}
	
	Spriteset_Battle.prototype.loadNewNomalBattleStandPicture = function(name) {
		//複数の場合は引数でactor取る
		const actor = $gameParty.battleMembers()[0]
		const ind = $gameParty.battleMembers().indexOf(actor);
		this.battleStandPictures[ind].loadNewNomalBattleStandPicture(name);
	}
	
	
	Spriteset_Battle.prototype.setSkillStandPicture = function(skillId, actor) {
		if(!$dataSkills[skillId].meta.standPic){return};
		const nameArr = $dataSkills[skillId].meta.standPic.split(",");
		const f = $dataSkills[skillId].meta.changePicFrame;
		const frame = f ? f : changeFrameCount;
		const rand = Math.floor( Math.random()*nameArr.length );
		const name = nameArr[rand];
		this.setOneStandPicture(name, actor, frame);
	}
	
	//21/05/24 追記
	const _alias_Spriteset_Battle_isAnimationPlaying = Spriteset_Battle.prototype.isAnimationPlaying;
	Spriteset_Battle.prototype.isAnimationPlaying = function() {
		const a = _alias_Spriteset_Battle_isAnimationPlaying.call(this);
		const b = this.battleStandPictures.some(function(sprite) {
			return sprite.isAnimationPlaying();
		});
		return a || b;
	};

	//-----------------------------------------------------------------------------
	// Sprite_Actor
	//
	
	Sprite_Actor.prototype.update = function() {
	};
	
	Sprite_Actor.prototype.setBattler = function(battler) {
		Sprite_Battler.prototype.setBattler.call(this, battler);
	};

	Sprite_Actor.prototype.setupAnimation = function() {
	}
	
	Sprite_Actor.prototype.setupDamagePopup = function() {	
	}
	//-----------------------------------------------------------------------------
	// Sprite_BattleStandPicture
	//

	function Sprite_BattleStandPicture() {
		this.initialize.apply(this, arguments);
	}

	Sprite_BattleStandPicture.prototype = Object.create(Sprite_Battler.prototype);
	Sprite_BattleStandPicture.prototype.constructor = Sprite_BattleStandPicture;
	
	Sprite_BattleStandPicture.prototype.initialize = function(battler, pos) {
		Sprite_Battler.prototype.initialize.call(this, battler);
		this.damageShakeCount = 0;
		this.damageShakeDirection = 1;
		this.imagePosition = pos;
		this.imageCenterPosition = [pos[0] + BattleStandSize[0] / 2, pos[1] + BattleStandSize[1] / 2]
		this.createBattleStandPicture(battler);
		this.initVal();
	}
	
	Sprite_BattleStandPicture.prototype.updatePosition = function() {
	}
	
	Sprite_BattleStandPicture.prototype.setupDamagePopup = function() {
		if (this._battler.isDamagePopupRequested()) {
			var sprite = new Sprite_Damage();
			sprite.x = this.imageCenterPosition[0];
			sprite.y = this.imageCenterPosition[1];
			sprite.setup(this._battler);
			this._damages.push(sprite);
			this.parent.addChild(sprite);
			this._battler.clearDamagePopup();
			this._battler.clearResult();
		}
	};

	Sprite_BattleStandPicture.prototype.setMainSprite = function(layer) {
		this._mainSprite = new Sprite_Base();
		this._mainSprite.anchor.x = 0.5;
		this._mainSprite.anchor.y = 1;
		this._mainSprite.x = this.imageCenterPosition[0];
		this._mainSprite.y = this.imageCenterPosition[1];
		this.parent.addChild(this._mainSprite);
		this._effectTarget = this._mainSprite;
	};

	Sprite_BattleStandPicture.prototype.setEffectTarget = function(battler, pos) {
		this._effectTarget = this.animationLayer;
	}
	
	Sprite_BattleStandPicture.prototype.initVal = function() {
		this.preStandName = this.getBaseState();
		this.posingFlame = 0;
	}

	Sprite_BattleStandPicture.prototype.setupAnimation = function() {
		while (this._battler.isAnimationRequested()) {
			const data = this._battler.shiftAnimation();
			const animation = $dataAnimations[data.animationId];
			const mirror = data.mirror;
			const delay = animation.position === 3 ? 0 : data.delay;
			this.startAnimation(animation, mirror, delay);
			for (let i = 0; i < this._animationSprites.length; i++) {
				var sprite = this._animationSprites[i];
			}
		}
	}
	
	Sprite_BattleStandPicture.prototype.createBattleStandPicture = function(battler) {
		let imgName = ["avoid", "damage", "noDamage", "item"]
		this.HPRateNames = HPRateAndFileName.map(arr => arr[1]);
		this.HPRateNames.push("nomal")
		imgName = [...imgName, ...this.HPRateNames];
		battler.skills().forEach(function(skill){
			if(!$dataSkills[skill.id].meta.standPic){return};
			const names = $dataSkills[skill.id].meta.standPic.split(",");
			imgName = [...imgName, ...names];
		});
		if(nomalAttackSkillId == 1){
			const id1names = $dataSkills[1].meta.standPic.split(",")
			imgName = [...imgName, ...id1names];
		}
		let statePicNames = []
		$dataStates.forEach(function(state){
			if(state && state.meta.BSPC){statePicNames.push(state.meta.BSPC)}
		})
		this.imgName = [...imgName, ...statePicNames];
		this.loadNewClothes();
	}
	
	Sprite_BattleStandPicture.prototype.refreshClothes = function() {
		this.removeClothesSprite();
		this.loadNewClothes();
	}
	
	//spriteはvisibleがfalseならフレームレートに影響しない
	//全ての衣装差分を読み込んでおいても良いが一応新しい衣装が呼ばれた時に読み込み、Spriteを用意するようにする
	//新しい画像が読み込まれない不具合が見られた場合、最初にすべて読み込むようにする
	
	Sprite_BattleStandPicture.prototype.loadNewClothes = function() {
		this.spriteList = {};
		const val = $gameVariables.value(ChangeByClothingVariableId)
		this.imgName.forEach(name => this.createNewClothesSprite(name, val));
		if(!this.spriteList[this.getBaseState()]){
			this.createNewClothesSprite(this.getBaseState(), val)
		}
		this.spriteList[this.getBaseState()].visible = true;
	}
	
	Sprite_BattleStandPicture.prototype.createNewClothesSprite = function(name, val) {
		const sprite = new Sprite();
		sprite.bitmap = this.loadImage(name, val);
		sprite.visible = false;
		sprite.x = this.imagePosition[0];
		sprite.y = this.imagePosition[1];
		this.addChild(sprite);
		this.spriteList[name] = sprite;
	}
	
	/*
	//全ての衣装を予め読み込んでおく場合
	Sprite_BattleStandPicture.prototype.loadAllClothes = function() {
		this.spriteList = [];
		for(let i = 0; i <= DressKindAmount; i++){
			let hash = {};
			this.imgName.forEach(function(name){
				const sprite = new Sprite();
				sprite.bitmap = this.loadImage(name, val);
				sprite.visible = false;
				sprite.x = this.x;
				sprite.y = this.y;
				this.addChild(sprite);
				hash[name] = sprite;
			}.bind(this))
			this.spriteList.push(hash);
			
		}
		const val = $gameVariables.value(ChangeByClothingVariableId)
		this.spriteList[val]["nomal"].visible = true;
	}
	*/
	
	Sprite_BattleStandPicture.prototype.loadNewNomalBattleStandPicture = function(name) {
		const val = $gameVariables.value(ChangeByClothingVariableId)
		this.createNewClothesSprite(name, val);
	}
	
	Sprite_BattleStandPicture.prototype.removeClothesSprite = function() {
		if(!this.spriteList){return};
		if(!Object.keys(this.spriteList).length > 0){return};
		Object.keys(this.spriteList).forEach(key => this.removeChild(this.spriteList[key]));
	}
	
	Sprite_BattleStandPicture.prototype.getBaseState = function() {
		if($gameSystem.battleStandForceNomalName){
			return $gameSystem.battleStandForceNomalName;
		}
		let stateStand = "";
		this._battler.states().forEach(function(state){
			if($dataStates[state.id].meta.BSPC){stateStand = $dataStates[state.id].meta.BSPC}
		})
		if(stateStand != ""){return stateStand}
		let hpName = "nomal"
		HPRateAndFileName.forEach(function(arr){
			if(100 * this._battler.hp / this._battler.mhp <= Number(arr[0])){
				hpName = arr[1];
			}
		}.bind(this))
		return hpName
	}
	
	Sprite_BattleStandPicture.prototype.changeNomalPicture = function() {
		this.changePicture(this.getBaseState())
	}
	
	Sprite_BattleStandPicture.prototype.changePicture = function(name, frame = changeFrameCount) {
		if(this.preStandName == name){return}
		this.spriteList[this.preStandName].visible = false;
		this.spriteList[name].visible = true;
		this.preStandName = name;
		if(name == "damage"){this.startDamageShake()};
		if(this.HPRateNames.indexOf(name) < 0){this.posingFlame = frame} 
	}
	
	Sprite_BattleStandPicture.prototype.startDamageShake = function() {
		this.damageShakeCount = changeFrameCount;
	}
	
	Sprite_BattleStandPicture.prototype.loadImage = function(filename, val) {
		return ImageManager.loadBattleStandPicture(filename, this._battler.name(), val)
	}
	
	Sprite_BattleStandPicture.prototype.updateVisibility = function() {
	}

	Sprite_BattleStandPicture.prototype.update = function() {
		Sprite_Battler.prototype.update.call(this);
		this.updateActionPosiong();
		this.updateDamageShaking();
	}
	
	Sprite_BattleStandPicture.prototype.updateDamageShaking = function() {
		if(!this.damageShakeCount){return}
		if(this.damageShakeCount <= 0){return}
		const t = changeFrameCount - this.damageShakeCount;
		if(t % (changeFrameCount/damageShakeFrequency) == 0){this.damageShakeDirection = -this.damageShakeDirection};
		this.spriteList["damage"].x += damageShakeAmplitude*this.damageShakeDirection;
		if(this.damageShakeCount == 0){this.spriteList["damage"].x = this.imagePosition[0];}
		this.damageShakeCount--;
	}
	
	Sprite_BattleStandPicture.prototype.updateActionPosiong = function() {
		if(this.posingFlame <= 0){return}
		this.posingFlame--;
		if(this.posingFlame == 0){this.changeNomalPicture()}
	}
})();